*** mse-models.do
***
*** Calcuate MSE of monthly models
***
clear all
set more off
set type double
set maxvar 7000

global path = "$HOME/research/ssur"

*******************************
*** UPDATE THESE PARAMETERS ***
*******************************
* date of first and last forecast to evaluate
local start = tm(1976m1)
local stop = tm(2011m12)

*** CALCULATE FORECAST RESIDUALS

*** V1 UR DATA
tempfile v1ur
use $path/data/rtdata/v1ur.dta, clear
replace v1ur=v1ur/100
tscollap v1ur, to(q) gen(qdate)
qui replace v1ur = round(v1ur,.0001)
tsset qdate, q
save `v1ur'

** SSUR FORECASTS
tempfile ssur2
use $path/analysis-bpea/models/rt/rt-ssur2.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur2, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur2 = round(ur_ssur2,.0001)
save `ssur2'

** CONSTANT HAZRATE FORECASTS
tempfile ssur2hr
use $path/analysis-bpea/models/contrib/rt-contrib.dta, clear
rename ur_s ur_ssur_s
rename ur_f ur_ssur_f
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ssur_s ur_ssur_f, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ssur_s = round(ur_ssur_s,.0001)
qui replace ur_ssur_f = round(ur_ssur_f,.0001)
save `ssur2hr'

** u* FORECASTS
tempfile ustar
use $path/analysis-bpea/models/ustar/rt-ustar.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_ustar, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_ustar = round(ur_ustar,.0001)
save `ustar'

** ARIMA FORECASTS
tempfile arima
use $path/analysis-bpea/models/arima/rt-arima-15y.dta, clear
rename ur_ ur_arima
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur_arima, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_arima = round(ur_arima,.0001)
save `arima'

** VAR FORECASTS
tempfile var
use $path/analysis-bpea/models/var/rt-var.dta, clear
tsset fcdate mdate, m
* collapse to quarterly
tscollap ur, to(q) gen(qdate)
* keep horizon t+0 to t+4
keep if qdate>=qofd(dofm(fcdate)) & qdate<qofd(dofm(fcdate))+5
qui replace ur_var = round(ur_var,.0001)
save `var'

*** MERGE IN FORECASTS
use `ssur2', clear
merge 1:1 fcdate qdate using `ssur2hr', nogen
merge 1:1 fcdate qdate using `arima', nogen
merge 1:1 fcdate qdate using `var', nogen
merge 1:1 fcdate qdate using `ustar', nogen
tsset fcdate qdate, q

*keep if fcdate>=`start' & fcdate<=`stop'
keep if qdate>=tq(1951q1)

cap macro drop _varlist
foreach var in ssur2 ssur_s ssur_f arima var ustar {
  rename ur_`var' ur_`var'_
}
reshape wide ur_ssur2_ ur_arima_ ur_var_ ur_ustar ur_ssur_s_ ur_ssur_f_, i(qdate) j(fcdate)

*** MERGE IN V1 UR DATA
merge m:1 qdate using `v1ur', nogen keep(1 3)

forvalues i = `start'/`stop' {
  foreach var in ssur2 arima var ustar ssur_s ssur_f {
    gen res_`var'_`i' = 100*(v1ur-ur_`var'_`i')
  }
}
keep qdate res*
*save res-models.dta, replace
*/

*** CALCULATE STATISTICS
*use res-models.dta, replace
reshape long res_ssur2_ res_arima_ res_var_ res_ustar_ res_ssur_s_ res_ssur_f_, i(qdate) j(fcdate)
keep if fcdate>=`start' & fcdate<=`stop'
drop if res_ssur2==.
sort fcdate qdate
by fcdate: gen byte j = _n
replace j=j-1
drop qdate
order fcdate j
tsset j fcdate, m
format fcdate %tm
foreach var in ssur2 arima var ustar ssur_s ssur_f {
  rename res_`var'_ res_`var'
  gen se_`var' = res_`var'^2
}
reshape long res_ se_, i(fcdate j) j(model) s
rename res_ res
rename se_ se
egen mse = mean(se), by(j model)
gen rmse = sqrt(mse)

*** REPORT
cap log close
log using mse-models.log, text replace
sum fcdate if se!=.
format se res rmse %6.4f
local dfcbeg = string(qofd(dofm(r(min))),"%tq")
local dfcend = string(qofd(dofm(r(max))),"%tq")
noi disp _n "FOREACST EVALUATION"
noi disp "Evaluated over: `dfcbeg' to `dfcend'"
noi disp "Evaluated relative to: v1"
* OBS
noi disp _n "Observations" _c
noi table j model, c(freq) cell(11)
** MISS
*noi disp _n "Average miss (percentage point)" _c
*noi table j model, c(mean res) cell(11)
* RMSE
noi disp _n "Root mean squared error (percentage point)" _c
noi table j model, c(mean rmse) cell(11) format(%3.2f)

cap log close

if "$S_CONSOLE"=="console" exit, STATA clear
